;############################################################
;#                                                          #
;#  File:           CDev.asm                                #
;#  Version:        3.0                                     #
;#  Author:                                                 #
;#  Copyright:      (c) 1989 by Apple Computer, Inc.        #
;#  Developer Technical Support Apple II Sample Code        #
;#                                                          #
;#  Description:    This file contains the assembler needed #
;#                  by the Shell CDEV on the IIGS.          #
;#                                                          #
;#----------------------------------------------------------#
;#                                                          #
;#  Development History:                                    #
;#                                                          #
;#  Who     Date        The Modification                    #
;#  ---     --------    ----------------                    #
;#                                                          #
;############################################################

         copy  E16.CDev

root     start
; just a dummy segment so all the code goes into the .A file
         end

;############################################################
;#                                                          #
;#  CDEV executable module                                  #
;#                                                          #
;############################################################

; This routine is eventually linked and then placed into a CDev code resource.  The only
; requirements are that this routine is at the beginning of the resource so if the CDev has
; any other routines they must follow this one.  The CDev's resource fork is always opened
; when a call to the CDev is made.  The CDev can also assume that the current port is set to
; the control panel window except in the boot message, where QuickDraw isn't even started,
; and in the About message, where it is the port of the help window.  All normal managers 
; will be started up for all calls except the boot call, which will only have miscTools and
; Resource Manager started.

CDEV     start

save_dbr equ   $01
retAddr  equ   $02
data2    equ   $05
data1    equ   $09
message  equ   $0D
retCode  equ   $0F

         phb                            ;save DBR
         tsc                            ;get stack pointer
         phd                            ;save original direct page
         tcd                            ;make local direct page

         phk                            ;set DBR to PBR
         plb

         stz   retCode                  ;initialize return code
         stz   retCode+2

         lda   message                  ;get message value
         cmp   #RunCDEV+1               ;valid message number?
         bcc   good_message             ;yes...
         lda   #reserved1               ;else put it in range
good_message   anop
         dec   a                        ;fix for indexing
         asl   a                        ;multiply by 2
         tax                            ;put into index register
         lda   case_table,x             ;get address of correct routine
         pha                            ;put on stack
         rts                            ;and do the 'rts' trick

case_table     anop
         dc    i2'Machine_msg-1'        ;case MachineCDEV
         dc    i2'Boot_msg-1'           ;case BootCDEV
         dc    i2'ShutDown_msg-1'       ;case ShutDownCDEV
         dc    i2'Init_msg-1'           ;case InitCDEV
         dc    i2'Close_msg-1'          ;case CloseCDEV
         dc    i2'Events_msg-1'         ;case EventsCDEV
         dc    i2'Create_msg-1'         ;case CreateCDEV
         dc    i2'About_msg-1'          ;case AboutCDEV
         dc    i2'Rect_msg-1'           ;case RectCDEV
         dc    i2'Hit_msg-1'            ;case HitCDEV
         dc    i2'Run_msg-1'            ;case RunCDEV
         dc    i2'null_msg-1'           ;case reserved1 through NeverUsed2

;----------------------------------------------------------------------------------------------------
; If the wantBoot flag is set, this routine will be called during the startup sequence.  The
; control panel takes care of drawing the "boot" icon.  When this call is made, the machine
; state is bad at best.  QuickDraw is not even started up.  The parameters to this call are
; undefined.

Boot_msg anop
         bra   exit
         
;----------------------------------------------------------------------------------------------------
; This is called if the wantMachine bit is set in the CDev flaags.  It enables the CDev to do
; further checking to see if it makes sense for the CDev to be visible to the user or not.
; For instance, if the CDev controls a setting for some hardware, we could check to see if
; the hardware is really connected.  The parameters are undefined for this call and the result
; is passed back as the function result.  0 = don't show this cdev, <>0 = show this CDev.
; The control panel will do some machine checking even before calling this routine by checking
; the ROM version number against the machine field of the CDev flags resource.

Machine_msg    anop
         bra   exit

;----------------------------------------------------------------------------------------------------
; If the wantCreate bit is set, this message is called with the control panel's window ptr 
; passed in data1.  The cdev must create any controls it has during this call.  The CDEV's 
; resource fork is open during this call so resource manager calls can be made.  All controls
; rectangles MUST be relative to 0,0.  The control panel handles offsetting controls
; to the proper place in the window.  Initialization of the controls needs to be done in
; the InitCDEV call.  Just create the controls in this call.

Create_msg     anop
         jsr   do_Create                ;go create the controls
         bra   exit                     ;then return to caller

;----------------------------------------------------------------------------------------------------
; If the wantInit flag is set, then this message is passed with data1 = the control panel's
; window ptr.  By  this time the CreateCDEV call will have been made and thus the controls
; used by the CDEV created.  This call enables the CDEV to initialize the controls before 
; they are displayed.

Init_msg anop
         jsr   do_Init
         bra   exit

;----------------------------------------------------------------------------------------------------
; If the wantAbout bit is set in the CDEV flags, this call is made when the user selects help.
; Data1 = window ptr to the help window.  The control panel automatically handles the icon, 
; author, and version # display.

About_msg      anop
         jsr   do_About
         bra   exit

;----------------------------------------------------------------------------------------------------
; If a CDEV has a different size data rectangle depending on some state, like the printer & 
; modem port cdev's, then you can get a chance to tell the control panel this by setting the 
; wantRect bit in the CDEV flags.  In this call, data1 is a ptr to the rect and can be 
; directly modified by the CDEV.

Rect_msg anop
         bra   exit

;----------------------------------------------------------------------------------------------------
; If the wantEvents bit is set, the control panel will call this routine with data1 = ptr to
; the event record.  This allows the cdev to intercept and even *gasp* change the event record
; before it is handled by the control panel.

Events_msg     anop
         bra   exit

;----------------------------------------------------------------------------------------------------
; If the CDEV wants to know when a control has been "hit", it can set the wantHit bit in the
; CDEV flags.  When called, data1 = Hdl to Ctl Hit & data2 = Ctl ID of hit control.  This message
; allows the CDEV to perform actions based on the control that was selected by the user.

Hit_msg  anop
         jsr   do_Hit
         bra   exit

;----------------------------------------------------------------------------------------------------
; This message is called if the "wantRun" bit is set in the CDEV flags.  It enables CDEVs like
; time to update the display.  It is called every 60th of a second - every time the DARun call
; is issued to the control panel. -no parameters are passed to this routine.

Run_msg  anop
         bra   exit

;----------------------------------------------------------------------------------------------------
; The CloseCDEV message is passed if the wantClose bit is set in the CDEV flags and the control
; panel is closing or when the user selects another CDEV.  During  this call data1 = windowPtr.
; In general, CDEVs can do any memory disposal and saving of settings during this call.  The
; disposal of the CDEV's controls is handled automatically by the Control Panel.

Close_msg      anop
         bra   exit

;----------------------------------------------------------------------------------------------------
; If the wantShutDown bit is set in the CDEV flags resource then this routine is called when
; the user either disables the CDEV or *someday* when the machine is being turned off.  It
; gives the CDEV a chance to turn itself off (or any hardware or software it controls).
; The parameters are undefined in this call.

ShutDown_msg   anop
         bra   exit

;----------------------------------------------------------------------------------------------------
; This label is here to handle any message values that are out of range.

null_msg anop
;----------------------------------------------------------------------------------------------------

exit     anop
         lda   save_dbr                 ;get saved DBR and low byte of return address
         sta   data1+2                  ;move up in stack frame
         lda   retAddr+1                ;get high word of return address
         sta   message                  ;move it up too
         pld                            ;restore original direct page
         tsc                            ;remove parms from stack
         clc
         adc   #10
         tcs
         plb                            ;restore original DBR
         rtl                            ;and return to control panel shell

;****************************************************************************************************
; do_Create - creates the popup controls

do_Create      anop
         pha                            ;make room on stack for returned control handle
         pha
         pei   data1+2                  ;put window pointer on stack
         pei   data1
         pea   3                        ;referenceDesc = pointer to list of pointers
         pea   CDEVLIST|-16             ;put address of pointer on stack
         pea   CDEVLIST
         ldx   #$3110                   ;NewControl2 call
         jsl   $e10000
         pla                            ;remove returned handle
         pla
         rts

;****************************************************************************************************
; do_Init - sets the initial values of the popup controls

do_Init  anop
         pea   1                        ;put current value of control on stack (for SetCtlValue)

         pha                            ;space for returned result
         pha
         pei   data1+2                  ;put window pointer on stack
         pei   data1
         pea   0
         pea   1                        ;control ID
         ldx   #$3010                   ;GetCtlHandleFromID call
         jsl   $e10000

         ldx   #$1910                   ;SetCtlValue call
         jsl   $e10000

         pea   1                        ;put current value of control on stack (for SetCtlValue)

         pha                            ;space for returned result
         pha
         pei   data1+2                  ;put window pointer on stack
         pei   data1
         pea   0
         pea   2                        ;control ID
         ldx   #$3010                   ;GetCtlHandleFromID call
         jsl   $e10000

         ldx   #$1910                   ;SetCtlValue call
         jsl   $e10000

         pea   1                        ;put current value of control on stack (for SetCtlValue)

         pha                            ;space for returned result
         pha
         pei   data1+2                  ;put window pointer on stack
         pei   data1
         pea   0
         pea   3                        ;control ID
         ldx   #$3010                   ;GetCtlHandleFromID call
         jsl   $e10000

         ldx   #$1910                   ;SetCtlValue call
         jsl   $e10000

         rts

;****************************************************************************************************
; do_About - creates the About static text control

do_About anop
         pha                            ;space for returned handle
         pha
         pei   data1+2                  ;put window pointer on stack
         pei   data1
         pea   0                        ;referenceDesc = pointer to single control
         pea   ABOUTCDEV1|-16           ;put pointer to about stuff on stack
         pea   ABOUTCDEV1
         ldx   #$3110                   ;NewControl2 call
         jsl   $e10000
         pla                            ;remove returned handle
         pla
         rts

;****************************************************************************************************
; do_Hit - handles a control 'hit'

do_Hit   anop
         lda   data2                    ;get Control ID
         cmp   #3                       ;is it three?
         bcc   not_three                ;no...
         pha                            ;else save value
         ldx   #$2c03                   ;SysBeep call
         jsl   $e10000
         pla                            ;retrieve ctl id
not_three      anop
         cmp   #2                       ;two?
         bcc   not_two
         pha                            ;save value
         ldx   #$2c03                   ;SysBeep
         jsl   $e10000
         pla
not_two  anop
         cmp   #1                       ;one?
         bcc   not_one
         ldx   #$2c03
         jsl   $e10000
not_one  anop
         rts

         end

;############################################################
;#                                                          #
;#  CDEV Control #1                                         #
;#                                                          #
;############################################################

CDEV1    data

         dc    i2'9'
         dc    i4'1'
         dc    i2'2,5,14,195'
         dc    i4'$87000000'
         dc    i2'$0040'
         dc    i2'$1004'
         dc    i4'0'
         dc    i2'76'
         dc    i4'CDEV1Menu'
         dc    i2'1'

CDEV1Menu anop
         dc    c'>> Item 1:\H'
         dc    i2'1'
         dc    i1'$0d'
         dc    c'== Impressive!\H'
         dc    i2'1'
         dc    i1'$0d'
         dc    c'== Elegant!\H'
         dc    i2'2'
         dc    i1'$0d'
         dc    c'== Amazing!\H'
         dc    i2'3'
         dc    i1'$0d'
         dc    c'== Stupendous!\H'
         dc    i2'4'
         dc    i1'$0d'
         dc    c'.'
         end

;############################################################
;#                                                          #
;#  CDEV Control #2                                         #
;#                                                          #
;############################################################

CDEV2    data
         dc    i2'9'
         dc    i4'2'
         dc    i2'17,5,29,195'
         dc    i4'$87000000'
         dc    i2'$0040'
         dc    i2'$1004'
         dc    i4'0'
         dc    i2'80'
         dc    i4'CDEV2Menu'
         dc    i2'1'

CDEV2Menu anop
         dc    c'>> Item 2:\H'
         dc    i2'2'
         dc    i1'$0d'
         dc    c'== Wow!\H'
         dc    i2'1'
         dc    i1'$0d'
         dc    c'== Golly!\H'
         dc    i2'2'
         dc    i1'$0d'
         dc    c'== Holy Cow!\H'
         dc    i2'3'
         dc    i1'$0d'
         dc    c'.'
         end

;############################################################
;#                                                          #
;#  CDEV Control #3                                         #
;#                                                          #
;############################################################

CDEV3    data
         dc    i2'9'
         dc    i4'3'
         dc    i2'32,5,44,195'
         dc    i4'$87000000'
         dc    i2'$0040'
         dc    i2'$1004'
         dc    i4'0'
         dc    i2'80'
         dc    i4'CDEV3Menu'
         dc    i2'1'

CDEV3Menu anop
         dc    c'>> Item 3:\H'
         dc    i2'3'
         dc    i1'13'
         dc    c'== Too Hip!\H'
         dc    i2'1'
         dc    i1'13'
         dc    c'== That''s All!\H'
         dc    i2'2'
         dc    i1'13'
         dc    c'.'
         end

;############################################################
;#                                                          #
;#  CDEV Control Lists                                      #
;#                                                          #
;############################################################

CDEVLIST data

         dc    i4'CDEV1'
         dc    i4'CDEV2'
         dc    i4'CDEV3'
         dc    i4'0'

         end

;############################################################
;#                                                          #
;#  CDEV 'About' control                                    #
;#                                                          #
;############################################################

AboutCDEV1     data

         dc    i2'8'
         dc    i4'1'
         dc    i2'38,5,138,280'
         dc    i4'$81000000'
         dc    i2'$0000'
         dc    i2'$1000'
         dc    i4'0'
         dc    i4'theText'
         dc    i2'endText-theText'
         
theText  anop
         dc    c'This CDEV shows how easy it is to create a CDEV on the AppleIIgs.'
endText  anop

         end
